<?php
class DbManager {
    static private $connection = null ;
    
    static function getConnection() {
        if( self::$connection !== null ) {
            return self::$connection ;
        }
        
        $db_host     = ConfManager::get( "/configuration/db/host" ) ;
        $db_username = ConfManager::get( "/configuration/db/username" ) ;
        //$db_password = ConfManager::get( "/configuration/db/password" ) ;
        
        //$sql = "host=$db_host dbname=dtasdb port=5432 user=$db_username password=$db_password" ;
        $sql = "host=$db_host dbname=dtasdb port=5432 user=$db_username" ;
        if( ( self::$connection = pg_connect( $sql ) ) == false ) {
            throw new Exception( "FailToConnectDb: host=$db_host" ) ;
        }
        
        return self::$connection ;
    }
    
    static function closeConnection() {
        if( self::$connection !== null ) {
            pg_close( self::$connection ) ;
        }
    }
    
    static function query( $sql ) {
        if( ( $result = pg_query( self::getConnection(),
                                  $sql ) ) === false ) {
                                         
            throw new Exception( "FailToExecuteSqlStatement: '$sql', msg=" . pg_last_error() ) ;
        }

        return $result ;
    }
    
    static function query_params( $sql, $params ) {
        if( ( $result = pg_query_params( self::getConnection(),
                                         $sql,
                                         $params ) ) == false ) {
                                         
            throw new Exception( "FailToExecuteSqlStatement: '$sql', msg=" . pg_last_error() ) ;
        }
        
        return $result ;
    }
}

if( realpath( $_SERVER[ "SCRIPT_NAME" ] ) == realpath( __FILE__ ) ) {
}
